/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hsc.common.util.HSCPanelBean;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardConstants;
import com.ibm.hsc.iw.WizardFrameBean;
import com.ibm.hsc.iw.WizardPopUpPanel;
import com.ibm.hsc.iw.WizardTaskException;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletTerminatingException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import java.io.Serializable;
import java.util.Map;

public abstract class WizardTaskBean
extends HSCPanelBean
implements Serializable {
    private static final String TRACE_MASKD = "JIWZWTBD";
    private static final String TRACE_MASKF = "JIWZWTBF";
    private static final String TRACE_MASKT = "JIWZWTBT";

    protected WizardTaskBean() {
        super.setBeanName(this.toString());
    }

    public static void main(String[] stringArray) {
        if (Trace.LEVEL >= 3) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(' ');
                stringBuffer.append(stringArray[i]);
            }
            Trace.trace(TRACE_MASKD, "main() called with the following parameters :" + stringBuffer.toString());
        }
    }

    public final void parentalAction(TaskActionEvent taskActionEvent, PanelBean panelBean) {
        Serializable serializable = null;
        PanelTaskletRequest panelTaskletRequest = null;
        UserTaskManager userTaskManager = null;
        try {
            if (taskActionEvent != null) {
                panelTaskletRequest = new PanelTaskletRequest((Object)(this.getBeanName() + '.' + taskActionEvent.getActionCommand()));
                if ("NextButton".equals(taskActionEvent.getActionCommand())) {
                    serializable = this.nextButtonHit();
                    panelTaskletRequest.setData("Action", (Object)"NextButton");
                } else if ("BackButton".equals(taskActionEvent.getActionCommand())) {
                    serializable = this.backButtonHit();
                    panelTaskletRequest.setData("Action", (Object)"BackButton");
                }
                panelTaskletRequest.setData("Source", (Object)this.getBeanName());
                panelTaskletRequest.setData("Data", (Object)serializable);
                WizardFrameBean.postAndWaitForResponse(panelBean, panelTaskletRequest);
            }
        }
        catch (WizardTaskException wizardTaskException) {
            if (wizardTaskException.isShouldBeDisplayed()) {
                userTaskManager = panelBean.getUserTaskManager();
                if (userTaskManager != null) {
                    try {
                        WizardTaskBean.showMessageBox(userTaskManager, wizardTaskException.getTitle(), wizardTaskException.getMsgs());
                    }
                    catch (HException hException) {
                        new AusMicrocodeLog(WizardConstants.LOG_INFO, 8, hException).writeEntryFromTaskletClient();
                    }
                } else {
                    new AusMicrocodeLog(WizardConstants.LOG_INFO, 9).writeEntryFromTaskletClient();
                }
            } else if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "WizardTaskException thrown that will not be displayed by the wizard infrastructure: " + wizardTaskException);
            }
        }
        catch (Throwable throwable) {
            new AusMicrocodeLog(WizardConstants.LOG_INFO, 15, throwable).writeEntryFromTaskletClient();
        }
    }

    public abstract Serializable nextButtonHit() throws WizardTaskException;

    public abstract Serializable backButtonHit();

    public final void verifyChanges() throws IllegalUserDataException {
    }

    public final void save() {
    }

    public final void postTask(Serializable serializable) {
        PanelTaskletRequest panelTaskletRequest = null;
        panelTaskletRequest = new PanelTaskletRequest((Object)this.getUniqueBeanName());
        panelTaskletRequest.setData("Action", (Object)"FramePostTask");
        panelTaskletRequest.setData("Source", (Object)this.getUniqueBeanName());
        panelTaskletRequest.setData("Data", (Object)serializable);
        super.postTaskletRequest(panelTaskletRequest);
    }

    public final Serializable callTask(Serializable serializable) throws WizardTaskException {
        PanelTaskletRequest panelTaskletRequest = null;
        Map map = null;
        Serializable serializable2 = null;
        panelTaskletRequest = new PanelTaskletRequest((Object)this.getUniqueBeanName());
        panelTaskletRequest.setData("Action", (Object)"FrameCallTask");
        panelTaskletRequest.setData("Source", (Object)this.getUniqueBeanName());
        panelTaskletRequest.setData("Data", (Object)serializable);
        try {
            map = super.getIncrementalData(panelTaskletRequest);
        }
        catch (TaskletTerminatingException taskletTerminatingException) {
            throw new WizardTaskException(null, (HSCLocalizableMsg)null);
        }
        serializable2 = (Serializable)map.get("Data");
        return serializable2;
    }

    public final void update(Object object) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "->update(" + object + ")");
        }
        this.displayComplete((Serializable)object);
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<-update(...)");
        }
    }

    public final void display(String string, String string2, String string3, Serializable serializable) {
        PanelTaskletRequest panelTaskletRequest = null;
        panelTaskletRequest = new PanelTaskletRequest((Object)(this.getBeanName() + '.' + "FrameDisplayPanel"));
        panelTaskletRequest.setData("Action", (Object)"FrameDisplayPanel");
        panelTaskletRequest.setData("Source", (Object)this.getBeanName());
        panelTaskletRequest.setData("Data", (Object)new WizardPopUpPanel(string, string2, string3, serializable));
        WizardFrameBean.postAndWaitForResponse(this, panelTaskletRequest);
    }

    public void displayComplete(Serializable serializable) {
    }

    public static void showNoChoiceMessageBox(UserTaskManager userTaskManager, LocalizableText localizableText, HSCLocalizableMsg hSCLocalizableMsg) {
        if (userTaskManager != null) {
            try {
                WizardTaskBean.showMessageBox(userTaskManager, localizableText, hSCLocalizableMsg);
            }
            catch (HException hException) {
                new AusMicrocodeLog(WizardConstants.LOG_INFO, 8, hException).writeEntryFromTaskletClient();
            }
        } else {
            new AusMicrocodeLog(WizardConstants.LOG_INFO, 9).writeEntryFromTaskletClient();
        }
    }

    public final void enableNextButton(boolean bl) {
        WizardFrameBean wizardFrameBean = null;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "->enableNextButton(" + bl + ")");
        }
        if ((wizardFrameBean = WizardFrameBean.getInstance()) != null) {
            if (Trace.LEVEL >= 2) {
                Trace.trace(TRACE_MASKF, "enabling/disabling next button");
            }
            wizardFrameBean.enableNextButton(bl);
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<-enableNextButton(...)");
        }
    }
}

